% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbn.timeseries.R
\name{bbn.timeseries}
\alias{bbn.timeseries}
\title{Time Series Prediction with Bayesian Belief Network}
\usage{
bbn.timeseries(bbn.model, priors1, timesteps = 5, disturbance = 1)
}
\arguments{
\item{bbn.model}{A matrix or dataframe of interactions between different model \code{nodes}.}

\item{priors1}{An X by 2 array of initial changes to the system under investigation.
The first column should be a -4 to 4 (including 0) integer value for each \code{node} in the network with negative values
indicating a decrease and positive values representing an increase. 0 represents no change.}

\item{timesteps}{This is the number of \code{timesteps} the model performs. Default = 5.
Note, \code{timesteps} are arbitrary and non-linear. However, something occurring in \code{timestep 2}, should occur before \code{timestep 3}.}

\item{disturbance}{Default = 1.
1 creates a prolonged or press \code{disturbance} as per \code{\link{bbn.predict}}.
Essentially \code{prior} values for each manipulated \code{node} are at least maintained (if not increased through reinforcement in the model) over all \code{timesteps}.
2 shows a brief pulse \code{disturbance}, which can be useful to visualise changes as peaks and troughs in increase and decrease of \code{nodes} can propagate through the network.}
}
\value{
Plots for each \code{node} showing the predicted change over time.
}
\description{
\code{bbn.timeseries()} performs time series predictions using a Bayesian Belief Network (\code{BBN}) model based on a single \code{prior} scenario.
It generates figures illustrating how parameters change over time for all or selected \code{nodes}.
}
\examples{
data(my_BBN, combined)
bbn.timeseries(bbn.model = my_BBN, priors1 = combined, timesteps=6, disturbance=1)

}
