% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bde.R
\name{bde_data}
\alias{bde_data}
\title{Fetch Banco de España (BdE) data}
\source{
\url{https://www.bde.es/webbe/en/estadisticas/recursos/api-estadisticas-bde.html}
}
\usage{
bde_data(key, time_range = NULL, lang = "en")
}
\arguments{
\item{key}{(\code{character()})\cr
The series keys to query.}

\item{time_range}{(\code{NULL} | \code{character(1)} | \code{integer(1)})\cr
The time range for the data. Can be an annual range (e.g., \code{2024}) or a frequency-based code:
\itemize{
\item Daily frequency (D): \code{"3M"} (last 3 months), \code{"12M"}, \code{"36M"}
\item Monthly frequency (M): \code{"30M"}, \code{"60M"}, \code{"MAX"} (entire series)
\item Quarterly frequency (Q): \code{"30M"}, \code{"60M"}, \code{"MAX"}
\item Annual frequency (A): \code{"60M"}, \code{"MAX"}
}

If \code{NULL} (default), returns the smallest range for the series frequency
(e.g., \code{"30M"} for monthly series).}

\item{lang}{(\code{character(1)})\cr
Language to query, either \code{"en"} or \code{"es"}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} with the requested data.
}
\description{
Retrieve time series data from the BdE statistics API.
}
\details{
You can search for the series codes in the
\href{https://app.bde.es/bie_www/bie_wwwias/xml/Arranque.html}{BIEST} application or in the tables
published by the Banco de España.
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
\donttest{
bde_data("D_1NBAF472", time_range = "30M")
bde_data(c("DTNPDE2010_P0000P_PS_APU", "DTNSEC2010_S0000P_APU_SUMAMOVIL"), time_range = "MAX")
bde_data("DEEQ.N.ES.W1.S1.S1.T.B.G._Z._Z._Z.EUR._T._X.N.ALL", time_range = 2024)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other data: 
\code{\link{bbk_data}()},
\code{\link{bbk_series}()},
\code{\link{bdf_codelist}()},
\code{\link{bdf_data}()},
\code{\link{bdf_dataset}()},
\code{\link{boc_data}()},
\code{\link{boe_data}()},
\code{\link{ecb_data}()},
\code{\link{onb_data}()},
\code{\link{snb_data}()}
}
\concept{data}
