% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varstan.R
\name{extract_stan}
\alias{extract_stan}
\title{Extract chains of an \code{stanfit} object implemented in \code{rstan} package}
\usage{
extract_stan(
  object,
  pars,
  permuted = TRUE,
  inc_warmup = FALSE,
  include = TRUE,
  ...
)
}
\arguments{
\item{object}{a \code{varstan} object}

\item{pars}{n optional character vector providing the parameter names
(or other quantity names) of interest. If not specified, all parameters
and other quantities are used. The log-posterior with name l\code{p__} is also
included.}

\item{permuted}{a logical scalar indicating whether the draws
after the \code{warm-up} period in each chain should be permuted and merged.
If FALSE, the original order is kept. For each \code{stanfit} object,
the permutation is fixed (i.e., extracting samples a second time will
give the same sequence of iterations).}

\item{inc_warmup}{a logical scalar indicating whether to include the
warm-up draws. This argument is only relevant if permuted is \code{FALSE}.}

\item{include}{a logical scalar indicating whether the parameters named
in pars should be included (TRUE) or excluded (FALSE).}

\item{...}{Further arguments passed to  \code{extract} function.}
}
\value{
a list with the posterior samples of the provided parameters.
}
\description{
Extract chains of an \code{stanfit} object implemented in \code{rstan} package
}
\examples{
\donttest{
 # Fitting a GARCH(1,1) model
 dat = garch(ipc,order = c(1,1,0))
 fit2 = varstan(dat,iter = 500,chains = 1)

 # Extracting the mean parameter
 mu0 = extract_stan(fit2,pars = "mu0")
}

}
\author{
Asael Alonzo Matamoros
}
