% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attenuation.R
\name{attenuation}
\alias{attenuation}
\title{Estimate attenuation of sound pressure level}
\usage{
attenuation(
  frequency,
  dist0,
  dist,
  temp = 20,
  rh = 60,
  pa = 101325,
  hab.att.coef = 0.02
)
}
\arguments{
\item{frequency}{Numeric vector of length 1 with frequency (in Hertz).}

\item{dist0}{Numeric vector of length 1 with distance (m) for the reference SPL.}

\item{dist}{Numeric vector of length 1 with distance (m) over which a sound propagates.}

\item{temp}{Numeric vector of length 1 with frequency (in Celsius). Default is 20.}

\item{rh}{Numeric vector of length 1 with relative humidity (in percentage). Default is 60.}

\item{pa}{Numeric vector of length 1 with atmospheric (barometric) pressure in Pa (standard: 101325, default). Used for atmospheric attenuation.}

\item{hab.att.coef}{Attenuation coefficient of the habitat (in dB/kHz/m).}
}
\value{
Returns the geometric, atmospheric and habitat attenuation (in dB) as well as the combined attenuation.
}
\description{
\code{attenuation} estimates atmospheric attenuation and atmospheric absorption.
}
\details{
Calculate the geometric, atmospheric and habitat attenuation and the overall expected attenuation (the sum of the other three) based on temperature, relative humidity, atmospheric pressure and sound frequency. Attenuation values are given in dB. The function is modified from http://www.sengpielaudio.com
}
\examples{
{
  # measure attenuation
  attenuation(frequency = 2000, dist = 50, dist0 = 1)
}
}
\references{
Araya-Salas, M., Grabarczyk, E. E., Quiroz-Oliva, M., Garcia-Rodriguez, A., & Rico-Guevara, A. (2025). Quantifying degradation in animal acoustic signals with the R package baRulho. Methods in Ecology and Evolution, 00, 1-12. https://doi.org/10.1111/2041-210X.14481
}
\seealso{
Other miscellaneous: 
\code{\link{add_noise}()},
\code{\link{noise_profile}()}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
\concept{miscellaneous}
