% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decompose.r
\name{decompose}
\alias{decompose}
\title{Decompose a data frame based on given normalised dependencies}
\usage{
decompose(
  df,
  schema,
  keep_rownames = FALSE,
  digits = getOption("digits"),
  check = TRUE
)
}
\arguments{
\item{df}{a data.frame, containing the data to be normalised.}

\item{schema}{a database schema with foreign key references, such as given by
\code{\link{autoref}}.}

\item{keep_rownames}{a logical or a string, indicating whether to include the
row names as a column. If a string is given, it is used as the name for the
column, otherwise the column is named "row". Set to FALSE by default.}

\item{digits}{a positive integer, indicating how many significant digits are
to be used for numeric and complex variables. A value of \code{NA} results
in no rounding. By default, this uses \code{getOption("digits")}, similarly
to \code{\link{format}}. See the "Floating-point variables" section for
\code{\link{discover}} for why this rounding is necessary for consistent
results across different machines. See the note in
\code{\link{print.default}} about \code{digits >= 16}.}

\item{check}{a logical, indicating whether to check that \code{df} satisfies
the functional dependencies enforced by \code{schema} before creating the
result. This can find key violations without spending time creating the
result first, but is redundant if \code{df} was used to create
\code{schema} in the first place.}
}
\value{
A \code{\link{database}} object, containing the data in \code{df}
within the database schema given in \code{schema}.
}
\description{
Decomposes a data frame into several relations, based on the given database
schema. It's intended that the data frame satisfies all the functional
dependencies implied by the schema, such as if the schema was constructed
from the same data frame. If this is not the case, the function will returns
an error.
}
\details{
If the schema was constructed using approximate dependencies for the same
data frame, \code{decompose} returns an error, to prevent either duplicate records
or lossy decompositions. This is temporary: for the next update, we plan to
add an option to allow this, or to add "approximate" equivalents of databases
and database schemas.
}
