% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPLS.R
\name{plotPLS}
\alias{plotPLS}
\title{PLS plot for asmbPLS-DA}
\usage{
plotPLS(fit.results, comp.X = 1, comp.Y = 2, group.name = NULL, legend = TRUE)
}
\arguments{
\item{fit.results}{The output of \code{\link[asmbPLS]{asmbPLSDA.fit}}.}

\item{comp.X}{A integer indicating which PLS component to be used for the 
X.axis. The default is 1.}

\item{comp.Y}{A integer indicating which PLS component to be used for the 
Y.axis. The default is 2.}

\item{group.name}{A vector containing the named character for each sample 
group. For \code{binary} outcome, first group name matches \code{Y.matrix} = 0, 
second group name matches \code{Y.matrix} = 1. For \code{multiclass} outcome,
 \code{i}th group name matches \code{i}th column of \code{Y.matrix} = 1.}

\item{legend}{A logical value indicating whether the legend should be added.
The default is TRUE.}
}
\value{
none
}
\description{
Function to visualize cluster of samples using super score of different PLS
components.
}
\details{
The function returns a plot to show cluster of samples using super score of 
different PLS components.
}
\examples{
## Use the example dataset
data(asmbPLSDA.example)
X.matrix = asmbPLSDA.example$X.matrix
Y.matrix.binary = asmbPLSDA.example$Y.matrix.binary
Y.matrix.multiclass = asmbPLSDA.example$Y.matrix.morethan2levels
X.dim = asmbPLSDA.example$X.dim
PLS.comp = asmbPLSDA.example$PLS.comp
quantile.comb = asmbPLSDA.example$quantile.comb
 
## asmbPLSDA fit for binary outcome
asmbPLSDA.fit.binary <- asmbPLSDA.fit(X.matrix = X.matrix, 
                                      Y.matrix = Y.matrix.binary, 
                                      PLS.comp = PLS.comp, 
                                      X.dim = X.dim, 
                                      quantile.comb = quantile.comb,
                                      outcome.type = "binary")

## asmbPLSDA fit for categorical outcome with more than 2 levels
asmbPLSDA.fit.multiclass <- asmbPLSDA.fit(X.matrix = X.matrix, 
                                          Y.matrix = Y.matrix.multiclass,
                                          PLS.comp = PLS.comp, 
                                          X.dim = X.dim, 
                                          quantile.comb = quantile.comb,
                                          outcome.type = "multiclass")

## visualization to show the cluster of samples using the first and the second super score
plotPLS(asmbPLSDA.fit.binary, comp.X = 1, comp.Y = 2)
plotPLS(asmbPLSDA.fit.multiclass, comp.X = 1, comp.Y = 2)
## custom group.name
plotPLS(asmbPLSDA.fit.binary, 
        comp.X = 1, 
        comp.Y = 2, 
        group.name = c("control", "case"))
plotPLS(asmbPLSDA.fit.multiclass, 
        comp.X = 1, 
        comp.Y = 2, 
        group.name = c("healthy", "mild", "severe"))


}
