% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argonFooter.R
\name{argonFooter}
\alias{argonFooter}
\title{Create a Boostrap 4 argon footer}
\usage{
argonFooter(..., has_card = FALSE, status = NULL, gradient = FALSE)
}
\arguments{
\item{...}{Footer content.}

\item{has_card}{Enable card rendering in the footer. FALSE by default.}

\item{status}{Footer status color. See \url{https://demos.creative-tim.com/argon-design-system/docs/foundation/colors.html}.}

\item{gradient}{Whether to apply a gradient. FALSE by default.}
}
\description{
Build an argon footer
}
\examples{
if(interactive()){
 library(argonR)
 argonFooter(
  has_card = FALSE,
  argonContainer(
    size = "lg",
    argonRow(
      argonColumn(
        width = 6,
        argonIconWrapper(
          iconTag = argonIcon("atom"),
          size = "lg",
          status = "success",
          shadow = TRUE,
          hover_shadow = TRUE
        ),
        argonH1(
          display = 3,
          "Insert anything in the footer"
        ),
        argonLead(
          "The Arctic Ocean freezes every winter and much of 
          the sea-ice then thaws every summer, and that process 
          will continue whatever"
        )
        ),
      argonColumn(
        width = 6,
        argonCarousel(
          width = 12,
          id = "carousel2",
          argonCarouselItem(
            src = "http://www.72pxdesigns.com/wp-content/uploads/2017/06/preview-814162.png",
            active = TRUE
          ),
          argonCarouselItem(
            src = "http://www.72pxdesigns.com/wp-content/uploads/2017/06/preview-814162.png",
            active = FALSE
          )
        )
      )
    )
   )
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
