% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formating.R
\name{tagger}
\alias{tagger}
\alias{bold_md}
\alias{italic_md}
\alias{superscript_md}
\alias{subscript_md}
\alias{header_md}
\title{Surrounds text with tags unless empty}
\usage{
tagger(x, tag = "<span>", right_tag = gsub("^<", "</", tag))

bold_md(x)

italic_md(x)

superscript_md(x)

subscript_md(x)

header_md(x, level = 1)
}
\arguments{
\item{x}{character vector}

\item{tag}{opening tag, e.g., \verb{<span>}}

\item{right_tag}{closing tag, e.g., \verb{</span>}. Defaults to the same value as the opening tag.}

\item{level}{heading level}
}
\value{
character vector
}
\description{
Surrounds text with tags unless empty
}
\examples{
x <- c("hello", "", NA)
tagger(x, "<span>")
bold_md(x)
italic_md(x)
superscript_md(x)
subscript_md(x)
header_md("Level 1")
header_md("Level 2", 2)
}
