% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thematic_trimming.R
\name{setThematicTrimming}
\alias{setThematicTrimming}
\title{Set the thematic trimming of an Antares Study}
\usage{
setThematicTrimming(
  selection_variables,
  type_select = c("add", "suppr"),
  opts = simOptions()
)
}
\arguments{
\item{selection_variables}{\code{character} of variables to add or remove.}

\item{type_select}{\code{character} select mode to add or remove (default add mode).}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}

Put only variables names you want to keep in study output.
You can add or remove variables (use study version >=v8.8).
}
\note{
You can put only variables according to version of study
}
\examples{
\dontrun{

# list of variables (version >= v8.8)
vect_select_vars <- list_thematic_variables()

##
# add all variables
##
setThematicTrimming(selection_variables = vect_select_vars$variable)

##
# remove all variables
##
setThematicTrimming(selection_variables = vect_select_vars$variable, 
                    type_select = "suppr")

}
}
