% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kangaroo-plot.R
\name{kangaroo_plot}
\alias{kangaroo_plot}
\title{Turn the data into a ggplot object for the animate function}
\usage{
kangaroo_plot(
  data,
  group_palette = NULL,
  shade_palette = NULL,
  rendering = "gganimate",
  time_dependent = FALSE,
  ...
)
}
\arguments{
\item{data}{The categorized data.}

\item{group_palette}{The vector of the palette used by the function to supply
the color of each group.}

\item{shade_palette}{The vector of the palette used by the function to supply
the color to the shaded area.}

\item{rendering}{The choice of method used to create and display the plot,
either gganimate or plotly.}

\item{time_dependent}{Logical. Should the visualization be time-dependent?
The default is FALSE.}

\item{...}{Additional arguments for customization. See details for more
information.}
}
\value{
Return a ggplot object.
}
\description{
This function takes in the data which has been prepared by the \code{\link[=anim_prep]{anim_prep()}}
or \code{\link[=anim_prep_cat]{anim_prep_cat()}} and return the ggplot object. The user can still modify
the plot as usual.
}
\details{
This function takes categorized data and generates a ggplot object.
The kangaroo plot is the plot that shows the movement between groups over
time. The point position and point size in the shaded area can be controlled
using additional arguments such as height, width, and size. For the shading
area, the alpha argument can be used.
}
\examples{
example <- anim_prep(data = dbl_change, id = id, values = values,
time = time, group = gp)

kangaroo_plot(example)

}
