% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnr_simple.r
\name{gnr_simple}
\alias{gnr_simple}
\title{checks species names against a variety of online databases
supports fuzzy partial matching, using the Global Names Resolver
(https://resolver.globalnames.org/). Modified on 11/18/2025 by
Vijay Patil (vpatil@usgs.gov) for
algaeClassify v2.0.5 (pending approval on CRAN).}
\usage{
gnr_simple(
  name,
  sourceid = NULL,
  best_match = TRUE,
  fuzzy_uninomial = TRUE,
  name_type = "canonical_full",
  higher = FALSE
)
}
\arguments{
\item{name}{character string binomial scientific name to resolve}

\item{sourceid}{integer vector with data source ids.
see https://resolver.globalnames.org/sources/}

\item{best_match}{boolean. Should the best match be returned based on score?}

\item{fuzzy_uninomial}{boolean. Use fuzzy matching for uninomial names?}

\item{name_type}{Specify format of matched names. Options are
'canonical_simple' (canonical binomial name), 'canonical_full' (with subspecies
or subgenera), or 'with_context' (with author and year appended).}

\item{higher}{boolean: Return higher taxonomic classifications?}
}
\value{
new data.frame with name matches, column indicating match type
and scores from Global Names Resolver (https://resolver.globalnames.org/).
Will contain a row of NAs if no matches found
}
\description{
checks species names against a variety of online databases
supports fuzzy partial matching, using the Global Names Resolver
(https://resolver.globalnames.org/). Modified on 11/18/2025 by
Vijay Patil (vpatil@usgs.gov) for
algaeClassify v2.0.5 (pending approval on CRAN).
}
\examples{
#Visit https://resolver.globalnames.org/data_sources to see all possible
#data sources for name checking.
name<-"Aphanazomenon flos-aquae"
#sourceid=3 for ITIS database
gnr_simple(name,sourceid=3) #search for best match from ITIS
gnr_simple(name,sourceid=NULL,best_match=FALSE) #search for all matches from any source
}
