% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpart-functions.R
\name{avg_characteristics_rpart}
\alias{avg_characteristics_rpart}
\title{Leaves Average Characteristics}
\usage{
avg_characteristics_rpart(tree, X)
}
\arguments{
\item{tree}{An \code{rpart} object.}

\item{X}{Covariate matrix (no intercept).}
}
\value{
A list storing each regression as an \code{\link[estimatr]{lm_robust}} object.
}
\description{
Computes the average characteristics of units in each leaf of an \code{\link[rpart]{rpart}} object.
}
\details{
\code{\link{avg_characteristics_rpart}} regresses each covariate on a set of dummies denoting leaf membership.
This way, we get the average characteristics of units in each leaf, together with a standard error.\cr

Leaves are ordered in increasing order of their predictions (from most negative to most positive).\cr

Standard errors are estimated via the Eicker-Huber-White estimator.
}
\examples{
## Generate data.
set.seed(1986)

n <- 1000
k <- 3

X <- matrix(rnorm(n * k), ncol = k)
colnames(X) <- paste0("x", seq_len(k))
D <- rbinom(n, size = 1, prob = 0.5)
mu0 <- 0.5 * X[, 1]
mu1 <- 0.5 * X[, 1] + X[, 2]
Y <- mu0 + D * (mu1 - mu0) + rnorm(n)

## Construct a tree.
library(rpart)
tree <- rpart(Y ~ ., data = data.frame("Y" = Y, X), maxdepth = 2)

## Compute average characteristics in each leaf.
results <- avg_characteristics_rpart(tree, X)
results

}
\references{
\itemize{
  \item Di Francesco, R. (2022). Aggregation Trees. CEIS Research Paper, 546. \doi{10.2139/ssrn.4304256}.
}
}
\seealso{
\code{\link{causal_ols_rpart}}, \code{\link{estimate_rpart}}
}
\author{
Riccardo Di Francesco
}
