% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_plane.r
\name{Point1D}
\alias{Point1D}
\title{1D points R6 Class}
\description{
\code{Point1D} is an \code{\link[R6:R6Class]{R6::R6Class()}} object representing one-dimensional points.
}
\examples{
p1 <- as_point1d(a = 1, b = 5)
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{a}}{Numeric vector that parameterizes the point via the equation \code{a * x + b = 0}.}

\item{\code{b}}{Numeric vector that parameterizes the point via the equation \code{a * x + b = 0}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Point1D-new}{\code{Point1D$new()}}
\item \href{#method-Point1D-print}{\code{Point1D$print()}}
\item \href{#method-Point1D-clone}{\code{Point1D$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Point1D-new"></a>}}
\if{latex}{\out{\hypertarget{method-Point1D-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Point1D$new(a, b)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{a}}{Numeric vector that parameterizes the line via the equation \code{a * x + b = 0}.}

\item{\code{b}}{Numeric vector that parameterizes the line via the equation \code{a * x + b = 0}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Point1D-print"></a>}}
\if{latex}{\out{\hypertarget{method-Point1D-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Point1D$print(n = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of lines to print.  If \code{NULL} print all of them.}

\item{\code{...}}{Passed to \code{\link[=format.default]{format.default()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Point1D-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Point1D-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Point1D$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
