% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.aeddo}
\alias{plot.aeddo}
\alias{plot}
\title{Create a complete 'ggplot' appropriate to a particular data type}
\usage{
\method{plot}{aeddo}(x, ...)
}
\arguments{
\item{x}{An \code{aeddo} object}

\item{...}{Additional arguments (not used).}
}
\value{
A 'ggplot' object for visualizing the time series data.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function generates a complete 'ggplot' object suitable for
visualizing time series data in an \code{aeddo} object. It creates a line
plot connecting the observations and adds points at each data point.
}
\examples{
# Create an example aeddo object
aeddo_data <- data.frame(
  time = as.Date(c(
    "2023-01-01",
    "2023-01-02",
    "2023-01-03",
    "2023-01-04",
    "2023-01-05",
    "2023-01-06"
  )),
  y = c(100, 120, 180, 110, 130, 140),
  n = 1
)

# Supply a model formula
fixed_effects_formula <- y ~ 1

# Choose a size for the rolling window
k <- 2
# ... and quantile for the threshold
sig_level <- 0.9

# Employ the algorithm
aeddo_results <- aeddo(
  data = aeddo_data,
  formula = fixed_effects_formula,
  k = k,
  sig_level = sig_level,
  exclude_past_outbreaks = TRUE,
  init_theta = c(1, 0),
  lower = c(-Inf, 1e-6),
  upper = c(Inf, 1e2),
  method = "L-BFGS-B"
)

# Create a ggplot visualization for the aeddo object
plot(aeddo_results)
}
\seealso{
\code{\link[=autoplot]{autoplot()}}
}
