% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/driver_void.R
\name{adbc_driver_load}
\alias{adbc_driver_load}
\title{Low-level driver loader}
\usage{
adbc_driver_load(
  x,
  entrypoint,
  version,
  driver,
  error,
  load_flags = adbc_load_flags(),
  additional_search_path_list = NULL)
}
\arguments{
\item{x, entrypoint}{An ADBC driver may be defined either as an init function
or as an identifier with an entrypoint name. A driver init func
must be an external pointer to a DL_FUNC with the type
\code{AdbcDriverInitFunc} specified in the adbc.h header.}

\item{version}{The version number corresponding to the \code{driver} supplied}

\item{driver}{An external pointer to an \code{AdbcDriver}}

\item{error}{An external pointer to an \code{AdbcError} or NULL}

\item{load_flags}{Integer flags generated by \code{\link[=adbc_load_flags]{adbc_load_flags()}}}

\item{additional_search_path_list}{A path list of additional locations to search for driver manifests}
}
\value{
An integer ADBC status code
}
\description{
Most users should use \code{\link[=adbc_driver]{adbc_driver()}}; however, this function may be used
to allow other libraries (e.g., GDAL) to access the driver loader.
}
