% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepping.cadence.histogram.R
\name{stepping.cadence.bands.folder.four.stepping.groups}
\alias{stepping.cadence.bands.folder.four.stepping.groups}
\title{Processes events files to produce histograms showing the distribution of stepping and
    weighted median stepping cadence across four groups of stepping bout duration.}
\usage{
stepping.cadence.bands.folder.four.stepping.groups(input_folder,
  output_folder, generate_charts = TRUE)
}
\arguments{
\item{input_folder}{The filepath for the folder where the events files to be processed are saved}

\item{output_folder}{The filepath for the folder where the generated files are to be saved}

\item{generate_charts}{Set TRUE if stacked histograms showing the distribution of stepping cadences are to be generated for each events file}
}
\description{
Processes a folder of events files and generates a faceted set of histograms
    for each events file showing the duration of stepping in different cadence bands
    (each cadence band has a width of 10 steps per minute) for stepping bouts of duration
    10 seconds to 1 minute, 1 minute to 5 minutes, 5 minutes to 10 minutes and 10 minutes plus.
    The weighted median cadence of stepping at each stepping bout duration is also calculated
    and indicated on the histogram.  The values of the weighted median cadence for each
    stepping duration across all the processed events files is also returned as a data.frame.
}
\examples{
input_folder <- paste(system.file("extdata", "", package = "activPAL"),"/",sep="")
output_folder <- paste(tempdir(),"/",sep="")

activPAL::stepping.cadence.bands.folder.four.stepping.groups(input_folder,output_folder,TRUE)
# Omitting a value for generate_charts results in the charts being saved in the output folder.
activPAL::stepping.cadence.bands.folder.four.stepping.groups(input_folder,output_folder)
}
