% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Abundant.R
\name{Abundant}
\alias{Abundant}
\alias{A005101}
\title{Abundant numbers}
\usage{
Abundant(n, gmp = TRUE)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{gmp}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A005101}{A005101}, an \emph{abundant} number is
a number whose proper divisors sum up to the extent greater than the number itself. First
6 abundant numbers are 12, 18, 20, 24, 30, 36.
}
\examples{
## generate first 30 Abundant numbers and print it
print(Abundant(30))

}
\seealso{
\code{\link{Deficient}}, \code{\link{Perfect}}
}
