% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Computation.r
\name{compareToFIMarket}
\alias{compareToFIMarket}
\title{Compares the welfare of the WoM campaign to that of a fully informed market}
\usage{
compareToFIMarket(campaign)
}
\arguments{
\item{campaign}{Word-of-Mouth campaign as instance of class \code{WoMCampaign}.}
}
\value{
Data frame containing the profit-maximizing price, the resulting demand, profit, consumer surplus and 
economic welfare for a fully informed market and a WoM market.
}
\description{
Compares the welfare of the WoM campaign to the welfare of a fully informed market assuming a uniformly distributed willingness to pay.
}
\examples{

network <- new("WoMNetwork", size = 1000, avgConnections = 5)
campaign <- new("WoMCampaign", network = network, seedingSize = 10, forwardProbability = 0.2)
comparison <- compareToFIMarket(campaign)
print(comparison)

}
\seealso{
\code{\link{computeOptimalPrice}} \code{\link{computeProfit}} \code{\link{computeConsumerSurplus}}
}
\author{
Michael Scholz \email{michael.scholz@th-deg.de}

Thomas Woehner \email{Thomas.Woehner@eah-jena.de}

Ralf Peters \email{ralf.peters@wiwi.uni-halle.de}
}
