% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw.f.BGM.cv.R
\name{bw.f.BGM.cv}
\alias{bw.f.BGM.cv}
\title{Cross-validation bandwidth selector for \insertCite{jones1991;textual}{WData} kernel density estimator}
\usage{
bw.f.BGM.cv(
  y,
  w = function(y) {
     ifelse(y >= 0, y, NA)
 },
  kernel = c("gaussian", "epanechnikov", "rectangular", "triangular", "biweight",
    "cosine", "optcosine"),
  lower = IQR(y) * n^(-0.2) * 2000^(-1),
  upper = IQR(y) * (log(n))^(0.2) * n^(-0.2) * 500,
  nh = 200L,
  tol = 0.1 * lower,
  plot = TRUE
)
}
\arguments{
\item{y}{A numeric vector containing the biased sample.}

\item{w}{A function representing the bias function applied to the data points. It must be evaluable and positive in each point of the sample the sample \code{y}. By default, it is set to the length-biased function.}

\item{kernel}{A character string specifying the kernel function. Available options: \code{"gaussian"}, \code{"epanechnikov"}, \code{"rectangular"}, \code{"triangular"}, \code{"biweight"}, \code{"cosine"} and \code{"optcosine"}.}

\item{lower}{Numeric value specifying the lower bound for bandwidth selection. Default is computed based on the interquartile range (IQR) and sample size.}

\item{upper}{Numeric value specifying the upper bound for bandwidth selection. Default is computed based on the interquartile range (IQR) and sample size.}

\item{nh}{An integer specifying the number of points to evaluate the cross-validation function. Default is 200.}

\item{tol}{Tolerance value used to check whether the minimum found lies at the boundaries of the interval; that is, the function will return a warning if the window minimizing the cross-validation function lies within \verb{[lower, lower+tol]} or \verb{[upper-tol, upper]}. Default is 10\% of the lower bound.}

\item{plot}{Logical value indicating whether to plot the cross-validation function. Default is \code{TRUE}.}
}
\value{
The optimal bandwidth value based on cross-validation criteria.
}
\description{
This function estimates the bandwidth for \insertCite{jones1991;textual}{WData} kernel density estimator using cross-validation criteria from \insertCite{guillamon1998;textual}{WData}. It iterates through a range of bandwidth values and computes the cross-validation score for each bandwidth. The bandwidth that minimizes the cross-validation function is selected as the optimal bandwidth.
}
\details{
The optimal bandwidth is the one that minimizes the cross-validation function, i.e.,
\deqn{
\widehat{h}_{f, \mathrm{CV}}= \mathrm{arg} \min_{h_{f}>0} \mathrm{CV}(h_{f}) = \mathrm{arg} \min_{h_{f}>0} \int_{-\infty}^{+\infty} \widehat{f}_{\mathrm{J},h_{f}}(y)^2 d y-2 \widehat{\mathbb{E}}[\widehat{f}_{\mathrm{J},h_{f}}].}
It holds that
\deqn{
\int_{-\infty}^{+\infty} \widehat{f}_{\mathrm{J}, h_{f}}(y)^2 dy = \frac{\widehat{\mu}_w^2}{n^{2} h_{f}} \sum_{i=1}^{n} \sum_{\substack{j=1}}^{n}
\frac{1}{w(Y_i)} \frac{1}{w(Y_j)}
(K \circ K) \left(\frac{Y_i-Y_j}{h_{f}} \right),
}
where \eqn{\circ} denotes convolution between two functions and \eqn{\widehat{\mathbb{E}}[\widehat{f}_{\mathrm{J}, h_{f}}]} is computed as
\deqn{
\widehat{\mathbb{E}}[\widehat{f}_{\mathrm{J}, h_{f}}] = \frac{\widehat{\mu}_w}{n} \sum_{i=1}^{n}  \frac{1}{w(Y_i)} \left( \sum_{j\neq i}  \frac{1}{w(Y_j)} \right)^{-1} \left(\sum_{j\neq i}  \frac{1}{w(Y_j)} K_{h_{f}}(Y_i-Y_j)\right).
}
This function computes the bandwidth that minimizes the cross validation function, \eqn{\mathrm{CV}},  on the interval \eqn{I} determined by \code{lower} and \code{upper}. By default,
\eqn{I} is the one suggested by \insertCite{borrajo2017;textual}{WData}:
\deqn{
I = \left[\frac{\mathrm{IQR}}{2000n^{1/5}}, \frac{500 \mathrm{IQR} \log(n)^{1/5}}{n^{1/5}}\right],
}
where IQR is the interquartile range.
}
\examples{
bw.f.BGM.cv(shrub.data$Width)
bw.f.BGM.cv(shrub.data$Width, kernel = "epanechnikov")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=df.jones]{df.jones}}
}
