% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_wrappers.R
\name{fitCopula}
\alias{fitCopula}
\alias{BCfitCopula}
\title{A dedicated method to use the estimation routines from the VineCopula package}
\usage{
BCfitCopula(copula, data, method = "ml")
}
\arguments{
\item{copula}{an object of the desired copula class}

\item{data}{a matrix holding the U(0,1) distributed data columns}

\item{method}{for BIVARIATE copulas either "ml" or "itau" for maximum likelihood estimation or inverse tau estimation (for one parameter families) respectively. See \code{\link[VineCopula]{BiCopEst}} for details. In case of a VINE copulas a list with names entries \code{StructureSelect} (default: FALSE), \code{indeptest} (default: FALSE), \code{familyset} (default: 'NA') and \code{indeptest} (default: FALSE). See \code{\link[VineCopula]{RVineStructureSelect}} or \code{\link[VineCopula]{RVineCopSelect}} for details.}
}
\value{
an object of class \code{\link[copula]{fitCopula}} as in the copula package.
}
\description{
Bivariate copulas are estimated based on \code{\link[VineCopula]{BiCopEst}} and vine copulas through \code{\link[VineCopula]{RVineStructureSelect}} or \code{\link[VineCopula]{RVineCopSelect}} depending on the \code{method} argument.
}
\examples{

u <- rCopula(1000, tawnT1Copula(c(3, 0.5)))

fitCopula(tawnT1Copula(), u)

}
