% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{fit_weights_model}
\alias{fit_weights_model}
\title{Method for fitting weight models}
\usage{
fit_weights_model(object, data, formula, label)
}
\arguments{
\item{object}{The object determining which method should be used, containing any slots containing user defined
parameters.}

\item{data}{\code{data.frame} containing outcomes and covariates as defined in \code{formula}.}

\item{formula}{\code{formula} describing the model.}

\item{label}{A short string describing the model.}
}
\value{
An object of class \code{te_weights_fitted}
}
\description{
Method for fitting weight models
}
\examples{
fitter <- stats_glm_logit(tempdir())
data(data_censored)
# Not usually called directly by a user
fitted <- fit_weights_model(
  object = fitter,
  data = data_censored,
  formula = 1 - censored ~ x1 + age_s + treatment,
  label = "Example model for censoring"
)
fitted
unlink(fitted@summary$save_path$path)
}
