% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10-helpers-spatial.R
\name{calculate_euclidean_distance}
\alias{calculate_euclidean_distance}
\title{Calculate Euclidean distance}
\usage{
calculate_euclidean_distance(lon1, lat1, lon2, lat2, unit)
}
\arguments{
\item{lon1}{Origin longitude.}

\item{lat1}{Origin latitude.}

\item{lon2}{Destination longitude vector.}

\item{lat2}{Destination latitude vector.}

\item{unit}{Distance unit.}
}
\value{
List with minimum distance and corresponding index.
}
\description{
Internal function to calculate Euclidean distance between coordinates,
adapted for geographic coordinate systems.
}
\details{
The Euclidean distance calculates the straight-line distance between two points,
adapted for geographic coordinates using spherical projection approximations.
This implementation accounts for Earth's curvature by applying latitude corrections.
}
\note{
This implementation adapts the standard Euclidean distance metric for geographic
coordinate systems by incorporating Earth's radius and latitude corrections.
}
\keyword{internal}
