% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-show.r
\name{format_tbl}
\alias{format_tbl}
\title{Format a table for display. The maximum number of columns
displayed is limited by the terminal width.}
\usage{
format_tbl(
  tbl,
  max_tbl_width,
  soft_table_width = max_tbl_width,
  max_row = 8,
  cell_formatter = common_formatter,
  delimiter = " ",
  truncate_marker = " ...",
  header_name = "",
  leading_text = NULL,
  include_row_names = TRUE,
  include_col_names = TRUE
)
}
\arguments{
\item{tbl}{A table-like object (e.g., matrix, data.frame).}

\item{max_tbl_width}{The maximum width for the table display.}

\item{soft_table_width}{A softer width limit for the table display, allowing the last column to exceed it.}

\item{max_row}{The maximum number of rows to display.}

\item{cell_formatter}{A function to format individual cells.}

\item{delimiter}{The delimiter to use for separating columns.}

\item{truncate_marker}{A marker to indicate truncation of the table.}

\item{header_name}{A string to print as the first element in the column names row. It only works when \code{include_col_names = TRUE}.}

\item{leading_text}{A string to print before the table. This can be used to indent the entire table. It can be a single string or a vector of strings. If it is a vector, it will be recycled to match the number of rows in the table.}

\item{include_row_names}{Logical, whether to include row names in the display.}

\item{include_col_names}{Logical, whether to include column names in the display.}
}
\value{
A formatted string vector representing the table. The length of the vector is the number of rows in the table.
}
\description{
Format a table for display. The maximum number of columns
displayed is limited by the terminal width.
}
\examples{
## Format the table
tbl <- data.frame(
    x = c(1, 123, 123456678, 1235678887644),
    y = c("abc", "this is a long string", "another long string", "yet another long string"),
    z = c(TRUE, FALSE, TRUE, FALSE),
    d = runif(4) * 100000
)
formatted_tbl <- format_tbl(tbl, max_tbl_width = 50, max_row = 3)
cat(formatted_tbl, sep = "\n")

}
\seealso{
\code{\link[=common_formatter]{common_formatter()}} for the cell formatting function and \code{\link[=pretty_number]{pretty_number()}} for formatting numeric values.
}
