% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals}
\alias{residuals}
\title{Estimate Residuals from Factor Model}
\usage{
residuals(factors, loadings_list, returns)
}
\arguments{
\item{factors}{A matrix containing the step-ahead-factors of from the \code{localPCA} function.}

\item{loadings_list}{A list where each element is a matrix of loadings corresponding
to the factors for each time period.}

\item{returns}{A matrix of asset returns with rows representing time periods and
columns representing assets.}
}
\value{
A matrix of residuals where each row corresponds to a time period and each
column corresponds to an asset.
}
\description{
This function estimates the residuals of asset returns after removing the effect
of factor-driven returns.
}
\details{
For each time period \eqn{t}, the function models the asset returns as:
\deqn{R_t = F_t \Lambda_t + \epsilon_t}
where \eqn{R_t} is the vector of asset returns, \eqn{F_t} is the t'th row of the factor matrix,
\eqn{\Lambda_t} is the loadings matrix, and \eqn{\epsilon_t} represents the residuals.

The residuals are computed as the difference between actual returns and the modeled
returns.
}
\keyword{internal}
