% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis.R
\name{sp_y_axis}
\alias{sp_y_axis}
\title{Modify Y-Axis of a SveltePlot Chart}
\usage{
sp_y_axis(
  sp,
  format = NULL,
  scale = "linear",
  ticks = 6,
  label = NULL,
  font_size_label = 14,
  font_size_ticks = 12,
  color_ticks = "black",
  color_label = "black"
)
}
\arguments{
\item{sp}{A SveltePlot htmlwidget object.}

\item{format}{Character string specifying the format of the x-axis labels. This should correspond to valid D3 format strings. Default is NULL. Documentation for the formats are here https://d3js.org/d3-format.}

\item{scale}{Character string indicating the scale type of the axis. Can be either "linear" or "log" for logarithmic. Default is "linear".}

\item{ticks}{Numeric value indicating the suggested number of tick marks. D3 will ultimately decide the exact number of ticks based on this suggestion. Default is 6.}

\item{label}{Character string for the label of the x-axis. Default is NULL.}

\item{font_size_label}{Numeric value specifying the font size of the x-axis label. Default is 14.}

\item{font_size_ticks}{Numeric value specifying the font size of the tick labels on the x-axis. Default is 12.}

\item{color_ticks}{Character string specifying the color of the tick labels on the x-axis. Default is "black".}

\item{color_label}{Character string specifying the color of the x-axis label. Default is "black".}
}
\value{
An object of class \code{htmlwidget} representing the plot with modified y-axis.
}
\description{
Similar to \code{\link{sp_x_axis}}, but for the y-axis. This function customizes the appearance and scaling of the y-axis,
including label formatting, tick marks, and label and tick colors.
}
\examples{
\dontrun{
library(SveltePlots)
# Assume `economics` data and prior `sp` and `sp_x_axis` calls
sp(...) |>
  sp_y_axis(label = "Unemployment", font_size_label = 18, font_size_ticks = 14)
}
}
