% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upgrade_sta_xml.R
\name{upgrade_sta_xml}
\alias{upgrade_sta_xml}
\title{Upgrading _sta.xml file(s) to a newer version}
\usage{
upgrade_sta_xml(
  file,
  out_dir,
  param_gen_file,
  stics_version = "V9.2",
  target_version = "V10.0",
  check_version = TRUE,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{file}{Path of a station (*_sta.xml) file or a vector of}

\item{out_dir}{Output directory path of the generated files}

\item{param_gen_file}{Path of the param_gen.xml file corresponding
to the file version}

\item{stics_version}{Name of the STICS version (VX.Y format)}

\item{target_version}{Name of the STICS version to upgrade files
to (VX.Y format)}

\item{check_version}{Perform version consistency with in stics_version input
with the file version and finally checking if the upgrade is possible
allowed to the target_version. If TRUE, param_gen_file is mandatory.}

\item{overwrite}{logical (optional),
TRUE for overwriting file if it exists, FALSE otherwise}

\item{...}{Additional input arguments}
}
\value{
None
}
\description{
Upgrading _sta.xml file(s) to a newer version
}
\details{
See SticsRFiles::get_stics_versions_compat() for listing versions
}
\examples{

dir_path <- get_examples_path(file_type = "xml", stics_version = "V9.2")

upgrade_sta_xml(
  file = file.path(dir_path, "file_sta.xml"),
  out_dir = tempdir(),
  param_gen_file = file.path(dir_path, "param_gen.xml")
)

}
