% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upgrade_sols_xml.R
\name{upgrade_sols_xml}
\alias{upgrade_sols_xml}
\title{Upgrading a sols.xml file to a newer version}
\usage{
upgrade_sols_xml(
  file,
  out_dir,
  param_gen_file,
  stics_version = "V9.2",
  target_version = "V10.0",
  check_version = TRUE,
  overwrite = FALSE
)
}
\arguments{
\item{file}{Path of a sols.xml file}

\item{out_dir}{Output directory path of the generated file}

\item{param_gen_file}{Path of the param_gen.xml file corresponding
to the file version}

\item{stics_version}{Name of the STICS version (VX.Y format)}

\item{target_version}{Name of the STICS version to upgrade files to
(VX.Y format)}

\item{check_version}{Perform version consistency with in stics_version input
with the file version and finally checking if the upgrade is possible
allowed to the target_version. If TRUE, param_gen_file is mandatory.}

\item{overwrite}{logical (optional),
TRUE for overwriting file if it exists, FALSE otherwise}
}
\value{
None
}
\description{
Upgrading a sols.xml file to a newer version
}
\details{
See SticsRFiles::get_stics_versions_compat() for listing versions
}
\examples{

dir_path <- get_examples_path(file_type = "xml", stics_version = "V9.2")

upgrade_sols_xml(
  file = file.path(dir_path, "sols.xml"),
  out_dir = tempdir(),
  param_gen_file = file.path(dir_path, "param_gen.xml")
)

}
