% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upgrade_plt_xml.R
\name{upgrade_plt_xml}
\alias{upgrade_plt_xml}
\title{Upgrading _plt.xml file(s) to a newer version}
\usage{
upgrade_plt_xml(
  file,
  out_dir,
  param_newform_file,
  param_gen_file,
  stics_version = "V9.2",
  target_version = "V10.0",
  check_version = TRUE,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{file}{Path of an plant (*_plt.xml) file or a vector of}

\item{out_dir}{Output directory path of the generated files}

\item{param_newform_file}{Path of the param_newform.xml file corresponding
to the file version}

\item{param_gen_file}{Path of the param_gen.xml file corresponding
to the file version}

\item{stics_version}{Name of the STICS version (VX.Y format)}

\item{target_version}{Name of the STICS version to upgrade files to
(VX.Y format)}

\item{check_version}{Perform version consistency between \code{stics_version}
and the file version, for finally checking if an upgrade is possible
allowed to the target_version. If TRUE, param_gen_file is mandatory.}

\item{overwrite}{logical (optional),
TRUE for overwriting file if it exists, FALSE otherwise}

\item{...}{Additional input arguments}
}
\value{
None
}
\description{
Upgrading _plt.xml file(s) to a newer version
}
\details{
See get_stics_versions_compat() for listing versions
}
\examples{

dir_path <- get_examples_path(file_type = "xml", stics_version = "V9.2")

upgrade_plt_xml(
  file = file.path(dir_path, "file_plt.xml"),
  out_dir = tempdir(),
  param_newform_file = file.path(dir_path, "param_newform.xml"),
  param_gen_file = file.path(dir_path, "param_gen.xml")
)

}
