% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridandmat.R
\name{CreateGrid}
\alias{CreateGrid}
\title{Create a Regularly Spaced Points Grid}
\usage{
CreateGrid(w, resolution, returnclass = "sp")
}
\arguments{
\item{w}{sp or sf object; the spatial extent of this object is used to 
create the regular grid.}

\item{resolution}{numeric; resolution of the grid (in map units). If 
resolution is not set, the grid will contain around 7500 points. (optional)}

\item{returnclass}{"sp" or "sf"; class of the returned object.}
}
\value{
The output of the function is a regularly spaced points grid
 with the extent of \code{w}.
}
\description{
This function creates a regular grid of points 
from the extent of a given spatial object and a given resolution.
}
\examples{
# Create a grid of paris extent and 200 meters
# resolution
library(SpatialPosition)
library(sf)
data(hospital)
mygrid <- CreateGrid(w = paris, resolution = 200, returnclass = "sf")
plot(st_geometry(mygrid), cex = 0.1, pch = ".")
plot(st_geometry(paris), border="red", lwd = 2, add = TRUE)
}
\seealso{
\link{CreateDistMatrix}
}
