% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickStewart.R
\name{quickStewart}
\alias{quickStewart}
\title{Create Polygons of Potentials Contours}
\usage{
quickStewart(
  x,
  spdf,
  df,
  spdfid = NULL,
  dfid = NULL,
  var,
  var2,
  typefct = "exponential",
  span,
  beta,
  resolution,
  mask,
  nclass = 8,
  breaks,
  bypassctrl = FALSE,
  returnclass = "sp"
)
}
\arguments{
\item{x}{sp or sf object; this is the set of known observations to 
estimate the potentials from.}

\item{spdf}{a SpatialPolygonsDataFrame.}

\item{df}{a data frame that contains the values to compute}

\item{spdfid}{name of the identifier field in spdf, default to the first column 
of the spdf data frame. (optional)}

\item{dfid}{name of the identifier field in df, default to the first column 
of df. (optional)}

\item{var}{name of the numeric field in df used to compute potentials.}

\item{var2}{name of the numeric field in df used to compute potentials. 
This field is used for ratio computation (see Details).}

\item{typefct}{character; spatial interaction function. Options are "pareto" 
(means power law) or "exponential".
If "pareto" the interaction is defined as: (1 + alpha * mDistance) ^ (-beta).
If "exponential" the interaction is defined as: 
exp(- alpha * mDistance ^ beta).
The alpha parameter is computed from parameters given by the user 
(\code{beta} and \code{span}).}

\item{span}{numeric; distance where the density of probability of the spatial 
interaction function equals 0.5.}

\item{beta}{numeric; impedance factor for the spatial interaction function.}

\item{resolution}{numeric; resolution of the output SpatialPointsDataFrame
(in map units). If resolution is not set, the grid will contain around 7250 
points. (optional)}

\item{mask}{sp or sf object; the spatial extent of this object is used to 
create the regularly spaced points output. (optional)}

\item{nclass}{numeric; a targeted number of classes (default to 8). Not used 
if breaks is set.}

\item{breaks}{numeric; a vector of values used to discretize the potentials.}

\item{bypassctrl}{logical; bypass the distance matrix size control (see 
\code{\link{CreateDistMatrix}} Details).}

\item{returnclass}{"sp" or "sf"; class of the returned object.}
}
\value{
A polyfon object is returned ("sp" or "sf", see \link{isopoly} Value).
}
\description{
This function is a wrapper around \link{stewart}, and \link{isopoly} functions. 
Providing only the main parameters of these functions, it simplifies a lot the computation of potentials. 
This function creates polygons of potential values. 
It also allows to compute directly the ratio between the potentials of two variables.
}
\details{
If var2 is provided, the ratio between the potentials of var (numerator) 
and var2 (denominator) is computed.
}
\examples{
# load data
data("hospital")
# Compute potentials
pot <- quickStewart(x = hospital,
                    var = "capacity",
                    span = 1000,
                    beta = 2, mask = paris, 
                    returnclass = "sf")
# cartography
if(require("cartography")){
  breaks <- sort(c(unique(pot$min), max(pot$max)), decreasing = FALSE)
  choroLayer(x = pot,
             var = "center", breaks = breaks,
             legend.pos = "topleft",
             legend.title.txt = "Nb. of Beds")
}

# Compute a ratio of potentials
hospital$dummy <- hospital$capacity + c(rep(50, 18))
pot2 <- quickStewart(x = hospital,
                     var = "capacity",
                     var2 = "dummy",
                     span = 1000,
                     beta = 2, 
                     mask = paris, 
                     returnclass = "sf")
# cartography
if(require("cartography")){
  breaks <- sort(c(unique(pot2$min), max(pot2$max)), decreasing = FALSE)
  choroLayer(x = pot2,
             var = "center", breaks = breaks,
             legend.pos = "topleft",legend.values.rnd = 3,
             legend.title.txt = "Nb. of DummyBeds")
}
}
\seealso{
\link{stewart}, \link{isopoly}
}
