% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_rate_curve.r
\name{growth_rate_curve}
\alias{growth_rate_curve}
\title{Function that creates a skewed sinusoidal growth rate (GR) curve
from a list of parameters}
\usage{
growth_rate_curve(G_par, years = 1, t_int = 1)
}
\arguments{
\item{G_par}{List of four parameters describing (in order) amplitude
(\code{G_amp}; in micrometer/day), period (\code{G_per}; in days), phase
(\code{G_pha} in day of the year), average growth rate (\code{G_av}; in
micrometer/day) and the skewness factor (\code{G_skw} between 0 and 100)}

\item{years}{Length of the preferred sinusoid in number of years (defaults
to 1)}

\item{t_int}{Time interval of sinusoidal record (in days)}
}
\value{
A matrix containing columns for time (in days) and GR
(in micrometer/day)
}
\description{
Takes the specified parameters for amplitude, period, phase, average value
and skewness factor as well as the number of years specified and the time
interval. It then creates a skewed sinusoid based on the boundary conditions.
The skewness factor (\code{G_skw}) determines whether the sinusoid is skewed
towards the front (\code{G_skw < 50}) or the back of the annual peak in
growth rate (\code{G_skw > 50}).
Used as intermediate step during iterative modeling.
}
\examples{
# Set parameters
G_amp <- 20
G_per <- 365
G_pha <- 100
G_av <- 15
G_skw <- 70
G_par <- c(G_amp, G_per, G_pha, G_av, G_skw)
# Run GR model function
GR <- growth_rate_curve(G_par, 1, 1)
}
\references{
\doi{10.1016/j.palaeo.2017.09.034}
}
