% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_data.R
\name{prepare_SensIAT_data}
\alias{prepare_SensIAT_data}
\title{Prepare Data for Sensitivity Analysis with Irregular Assessment Times}
\usage{
prepare_SensIAT_data(
  data,
  id.var,
  time.var,
  outcome.var,
  End,
  add.terminal.observations = TRUE
)
}
\arguments{
\item{data}{A data frame containing the data to be prepared.}

\item{id.var}{The variable in \code{data} that identifies the subject.}

\item{time.var}{The variable in \code{data} that identifies the time of the observation.}

\item{outcome.var}{The variable in \code{data} that contains the outcome of interest.}

\item{End}{The end time for the analysis. Observations with time greater than \code{End} will be filtered out.}

\item{add.terminal.observations}{Logical indicating whether to add terminal observations to the data (\code{TRUE}), or terminal observations have already been added (\code{FALSE}).}
}
\value{
A data frame with the following transformations:
\itemize{
\item Data filtered to time less than or equal to \code{End}.
\item Observations are arranged by \code{id.var} and \code{time.var}.
\item Terminal observations added if \code{add.terminal.observations} is \code{TRUE},
with \code{..time..} set to \code{End} and \code{..outcome..} set to \code{NA}, if the
subject has less observations than the maximum number of observations.
\item New variables created: \itemize{
\item \code{..id..} aliases \code{id.var},
\item \code{..time..} aliases \code{time.var},
\item \code{..outcome..} aliases \code{outcome.var},
\item \code{..visit_number..} is the visit number within each subject derived from \code{time.var},
\item \code{..prev_outcome..}, i.e. lag-outcome,  the outcome from the previous visit,
\item \code{..prev_time..}, i.e. lag-time, the time from the previous visit,
\item \code{..delta_time..}, the difference in time between the current and previous visit.
}
}
}
\description{
This function prepares the data for SensIAT analysis by transforming it into
a format suitable for the SensIAT models.
}
\examples{

prepare_SensIAT_data( SensIAT_example_data, Subject_ID, Time, Outcome, 830)

exdata <- tibble::tibble(ID=rep(1:2, c(3,5)),
                         Time=c(0, 30, 60,
                                0, 30, 60, 90, 120),
                         Outcome=floor(runif(8, 1, 100)))

prepare_SensIAT_data(exdata, ID, Time, Outcome, 120)

}
