% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SscSrsMean.R
\name{SscSrsMean}
\alias{SscSrsMean}
\title{Sample size calculator for estimation of population mean under SRS}
\usage{
SscSrsMean(CV_known, replace, alpha, re, N, preliminary_sample, cv_value = NA)
}
\arguments{
\item{CV_known}{Logical. TRUE if CV of the population is known; FALSE otherwise.}

\item{replace}{Logical. TRUE for SRSWR; FALSE for SRSWOR.}

\item{alpha}{Level of significance (e.g., 0.05 for 5\% level).}

\item{re}{Relative error in the estimate (e.g., 0.1 for 10\%).}

\item{N}{Population size. Use NA for SRSWR.}

\item{preliminary_sample}{Numeric vector. Preliminary sample data; NA if CV is known.}

\item{cv_value}{Numeric. Known CV when CV_known = TRUE; ignored if CV_known = FALSE.}
}
\value{
A list with the following components:
\describe{
  \item{Required sample size}{The required sample size for the given inputs.}
  \item{Additional sample units to be surveyed}{Only for unknown CV: additional units beyond preliminary sample size.}
}
}
\description{
The SscSrsMean function calculates the sample size required for estimation of population mean
based upon the availability of prior information on coefficient of variation (CV) of the
population under Simple Random Sampling (SRS) with or without replacement sampling design for
a given confidence level and relative error. Further, the function provides the required sample size
when population CV is known whereas it provides both required sample size and additional sample units
to be surveyed when population CV is unknown under both SRS with or without replacement.
}
\details{
Returns the sample size for estimation of the population mean under SRS with or without replacement.
For unknown CV, also returns the number of extra units needed beyond the preliminary sample.
}
\examples{
# Known CV, SRSWOR
SscSrsMean(TRUE, FALSE, 0.05, 0.2, 100, NA, cv_value = 0.3)

# Unknown CV, SRSWOR
prelim <- c(12, 14, 8, 5, 36, 24, 18, 17, 6, 9)
SscSrsMean(FALSE, FALSE, 0.05, 0.2, 100, prelim)

# Known CV, SRSWR
SscSrsMean(TRUE, TRUE, 0.05, 0.2, NA, NA, cv_value = 0.3)

}
\references{
Cochran, W. G. (1977). \emph{Sampling Techniques, 3rd Edition}. New York: John Wiley & Sons.

Singh, D. and Chaudhary, F.S. (1986). \emph{Theory and Analysis of Sample Survey Designs}. New York: John Wiley & Sons, Inc.

Sukhatme, P.V., Sukhatme, B.V., Sukhatme, S. and Asok, C. (1984). \emph{Sampling Theory of Surveys with Applications}. Iowa State University Press, Ames and Indian Society of Agricultural Statistics, New Delhi.
}
