% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_distances_radial.R
\name{plot_radial_distance}
\alias{plot_radial_distance}
\title{Radial Distance Visualization with Collision Avoidance}
\usage{
plot_radial_distance(
  distance_result,
  reference_type,
  id_col = "barcode",
  scale_radius = 1,
  show_labels = TRUE,
  palette = "Set2",
  label_padding = 0.15,
  center_label_expansion = 1.5
)
}
\arguments{
\item{distance_result}{Data.frame from calculate_nearest_distances()}

\item{reference_type}{Name of the reference cell type (center node)}

\item{id_col}{Name of ID column (default: "barcode")}

\item{scale_radius}{Scaling factor for layout (default: 1)}

\item{show_labels}{Whether to show distance labels (default: TRUE)}

\item{palette}{Color palette name (default: "Set2")}

\item{label_padding}{Radial padding for labels (default: 0.15)}

\item{center_label_expansion}{Center expansion for labels (default: 1.5)}
}
\value{
A ggplot2 object
}
\description{
Creates a radial plot with automatic label placement to prevent overlaps between
nodes and text labels.
}
\examples{
plot_radial_distance(distance_results,id_col = "Newbarcode",
                     reference_type = "Macrophages",label_padding = 0.3,
                     show_labels = TRUE,palette = "Dark2")
}
