% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpenMP.R
\name{OpenMP}
\alias{OpenMP}
\alias{openmp.on}
\alias{openmp.off}
\alias{openmp.threads}
\title{Control OpenMP}
\usage{
## enable OpenMP
openmp.on()

## disable OpenMP
openmp.off()

## set number of threads
openmp.threads(threads)
}
\arguments{
\item{threads}{A positive <\link{integer}>-value (Default: None). If \code{threads} is missing, the \code{openmp.threads()} returns the number of available threads. If \link{NULL} all available threads will be used.}
}
\value{
If OpenMP is unavailable, the function returns \link{NULL}.
}
\description{
Enable or disable OpenMP parallelization for computations.
\subsection{Disclaimer}{

This toggle is a brute-force implementation and does \strong{not} guard against data races or nested parallel regions.
Nested OpenMP regions can introduce subtle race conditions if multiple layers of parallelism access shared data concurrently.
If you combine this package’s OpenMP switch with other parallel machine-learning routines, you may encounter undefined behavior.
}
}
\examples{
\dontrun{
## enable OpenMP
SLmetrics::openmp.on()

## disable OpenMP
SLmetrics::openmp.off()

## available threads
SLmetrics::openmp.threads()

## set number of threads
SLmetrics::openmp.threads(2)
}


}
