% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simData.R
\name{f_four}
\alias{f_four}
\title{Function of x on a fourier basis}
\usage{
f_four(x, beta, js)
}
\arguments{
\item{x}{a vector of covariates}

\item{beta}{the parameter vector for the function f(X)}

\item{js}{the indices of the causal covariates in X}
}
\value{
the value of the function f(x)
}
\description{
Function of x on a fourier basis with a subset of covariates 
having a causal effect on Y using the parameters beta.
The function is given by:
\deqn{f(x_i) = \sum_{j = 1}^p 1_{j \in js} \sum_{k = 1}^K (\beta_{j, k}^{(1)} \cos(0.2 k x_j) +
\beta_{j, k}^{(2)} \sin(0.2 k x_j))}
}
\examples{
set.seed(42)
# simulation of confounded data
sim_data <- simulate_data_nonlinear(q = 2, p = 150, n = 100, m = 2)
X <- sim_data$X
j <- sim_data$j[1]
apply(X, 1, function(x) f_four(x, sim_data$beta, j))

}
\seealso{
\code{\link{simulate_data_nonlinear}}
}
\author{
Markus Ulmer
}
