% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Logger.R
\name{LoggerNull}
\alias{LoggerNull}
\title{LoggerNull: The no-logging Logger}
\value{
A new instance of the \code{LoggerNull} \link[R6:R6Class]{R6} class.
}
\description{
The \code{LoggerNull} class overwrites the functions of the \code{Logger} so no logging is produced.
Errors and warnings are still produced.
}
\examples{
  logger <- LoggerNull$new()

  logger$log_info("This message will not print!")
  logger$log_to_db(message = "This message will no be written in database!")
  try(logger$log_warn("This is a warning!"))
  try(logger$log_error("This is an error!"))
}
\section{Super class}{
\code{\link[SCDB:Logger]{SCDB::Logger}} -> \code{LoggerNull}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LoggerNull-new}{\code{LoggerNull$new()}}
\item \href{#method-LoggerNull-log_to_db}{\code{LoggerNull$log_to_db()}}
\item \href{#method-LoggerNull-finalize_db_entry}{\code{LoggerNull$finalize_db_entry()}}
\item \href{#method-LoggerNull-clone}{\code{LoggerNull$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="SCDB" data-topic="Logger" data-id="log_error"><a href='../../SCDB/html/Logger.html#method-Logger-log_error'><code>SCDB::Logger$log_error()</code></a></span></li>
<li><span class="pkg-link" data-pkg="SCDB" data-topic="Logger" data-id="log_info"><a href='../../SCDB/html/Logger.html#method-Logger-log_info'><code>SCDB::Logger$log_info()</code></a></span></li>
<li><span class="pkg-link" data-pkg="SCDB" data-topic="Logger" data-id="log_warn"><a href='../../SCDB/html/Logger.html#method-Logger-log_warn'><code>SCDB::Logger$log_warn()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggerNull-new"></a>}}
\if{latex}{\out{\hypertarget{method-LoggerNull-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{LoggerNull} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerNull$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Captures arguments given, but does nothing}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggerNull-log_to_db"></a>}}
\if{latex}{\out{\hypertarget{method-LoggerNull-log_to_db}{}}}
\subsection{Method \code{log_to_db()}}{
Matches the signature of \code{Logger$log_to_db()}, but does nothing.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerNull$log_to_db(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Captures arguments given, but does nothing}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggerNull-finalize_db_entry"></a>}}
\if{latex}{\out{\hypertarget{method-LoggerNull-finalize_db_entry}{}}}
\subsection{Method \code{finalize_db_entry()}}{
Matches the signature of \code{Logger$finalize_db_entry()}, but does nothing.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerNull$finalize_db_entry(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Captures arguments given, but does nothing}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggerNull-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LoggerNull-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerNull$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
