% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule_euler.R
\name{rule_euler}
\alias{rule_euler}
\title{Create an Euler Diagram for Association Rules}
\usage{
rule_euler(
  rules,
  fill_color = NULL,
  fill_alpha = 0.5,
  stroke_color = "black",
  stroke_size = 1,
  title = NULL,
  name_color = "black",
  name_size = 12,
  text_color = "black",
  text_size = 11,
  show_legend = FALSE,
  legend_position = "bottom",
  nrow = NULL,
  ncol = NULL
)
}
\arguments{
\item{rules}{A list of \code{rules} objects from the \code{arules} package.
The list must contain between 2 and 4 \code{rules} objects.}

\item{fill_color}{A character vector of valid R color names or hex color codes for filling the sets.
If \code{NULL}, default colors \code{c("red", "blue", "green", "purple")} will be used. Defaults to \code{NULL}.}

\item{fill_alpha}{A numeric value between 0 and 1 specifying the transparency of the fill colors. Defaults to \code{0.5}.}

\item{stroke_color}{A character string specifying the color of the set borders. Defaults to \code{"black"}.}

\item{stroke_size}{A positive numeric value specifying the size of the set borders. Defaults to \code{1}.}

\item{title}{A character string specifying the title of the Euler diagram. Defaults to \code{NULL}.}

\item{name_color}{A character string specifying the color of the set names. Defaults to \code{"black"}.}

\item{name_size}{A positive numeric value specifying the font size of the set names. Defaults to \code{12}.}

\item{text_color}{A character string specifying the color of the quantity labels (counts) in the diagram. Defaults to \code{"black"}.}

\item{text_size}{A positive numeric value specifying the font size of the quantities (counts). Defaults to \code{11}.}

\item{show_legend}{A logical value indicating whether to display a legend for the sets rather than labels. Defaults to \code{FALSE}.}

\item{legend_position}{A character string specifying the position of the legend. Must be one of \code{"top"}, \code{"bottom"}, \code{"left"}, or \code{"right"}. Defaults to \code{"bottom"}.}

\item{nrow}{An optional numeric value specifying the number of rows in the legend layout. If \code{NULL}, the number of rows is calculated automatically. Defaults to \code{NULL}.}

\item{ncol}{An optional numeric value specifying the number of columns in the legend layout. If \code{NULL}, the number of columns is calculated automatically. Defaults to \code{NULL}.}
}
\value{
A \code{plot} object displaying the Euler diagram visualization.
}
\description{
Generates an Euler diagram visualization for up to 4 sets of association rules.
The function displays the relationships between rule sets with customizable colors, transparency, and labels.
}
\examples{
library(arules)
data(BrookTrout)

# Discretize the BrookTrout dataset
discrete_bt <- dtize_df(BrookTrout, cutoff = "median")

# Generate the first set of rules with a confidence threshold of 0.5
rules1 <- apriori(
  discrete_bt,
  parameter = list(supp = 0.01, conf = 0.5, target = "rules")
)

# Generate the second set of rules with a higher confidence threshold of 0.6
rules2 <- apriori(
  discrete_bt,
  parameter = list(supp = 0.01, conf = 0.6, target = "rules")
)

# Create an Euler diagram to visualize the intersections between the rule sets
rule_euler(
  rules = list(conf0.5 = rules1, conf0.6 = rules2),
  title = "Euler Diagram of BrookTrout Rule Sets",
  fill_color = c("#7832ff", "lightgreen"),
  stroke_color = "darkblue"
)

}
