% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-simdata-car.R
\name{car_ps}
\alias{car_ps}
\title{Generate Pocock-Simon minimization treatment assignments}
\usage{
car_ps(z, treat, ratio, imb_measure, p_bc = 0.8)
}
\arguments{
\item{z}{The car_strata design matrix}

\item{treat}{A vector of length k (the number of treatment arms), which labels the treatment arms being compared.}

\item{ratio}{A vector of length k (the number of treatment arms), which indicates the allocation ratio, e.g., c(1,1,1) for equal allocation with three treatment arms.}

\item{imb_measure}{What measure of imbalance should be minimzed during randomization -- either "Range" or "SD"}

\item{p_bc}{The biased probability, i.e., the probability of assigning each patient to the arm that minimizes the imbalance. Default is 0.8}
}
\value{
\describe{
\item{res}{treatment assignment vector}
}

A vector of treatment assignments with labels from the `treat` argument, based on Pocock-Simon's minimization.
}
\description{
Generate Pocock-Simon minimization treatment assignments
}
\examples{

# Create car_strata variables
library(fastDummies)
library(dplyr)

x <- runif(100)
z <- cut(x, breaks=c(0, 0.25, 0.5, 0.75, 1.0))
z <- dummy_cols(z)
A <- car_ps(
  z=z[, 2:5],
  treat=c(0, 1, 2),
  ratio=c(1, 1, 1),
  imb_measure="Range"
)

}
\author{
Ting Ye Yanyao Yi
}
