% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_effect.R
\name{estimate_effect}
\alias{estimate_effect}
\title{Compute Estimates and Covariance Matrix}
\usage{
estimate_effect(
  ret,
  y,
  treatment,
  treatments_for_compare,
  data,
  prob_mat,
  post_strata,
  stabilize
)
}
\arguments{
\item{ret}{counterfactual prediction}

\item{y}{Observed outcome}

\item{treatment}{name of treatment}

\item{treatments_for_compare}{description}

\item{data}{(\code{data.frame}) data}

\item{prob_mat}{(\code{data.frame}) treatment assignment probability}

\item{post_strata}{(\code{character}) A string name of post-stratification variable}

\item{stabilize}{(\code{logical}) whether to stabilize}
}
\value{
A list of "estimate_effect" object with following elements:
\itemize{
\item \code{estimate}: estimate of the treatment effect.
\item \code{inner_variance}: estimate of the covariance matrix.
\item \code{method}: estimation method.
}
}
\description{
Compute Estimates and Covariance Matrix
}
