% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Analyses_functions_2.R
\name{RS_Index}
\alias{RS_Index}
\title{Relative strength index}
\usage{
RS_Index(X, period = 14, plot = FALSE, overbought = 70, oversold = 30)
}
\arguments{
\item{X}{A vector.}

\item{period}{Period length used for smoothing. Default is set to 14.}

\item{plot}{Logical: If \code{TRUE}, the time series and the
RSI are plotted (with \code{overbought} and
\code{oversold} levels) in the same window in interactive sessions.}

\item{overbought}{Horizontal line which indicates an overbought level in the RSI plot. Default is set to 70.}

\item{oversold}{Horizontal line which indicates an oversold level in the RSI plot. Default is set to 30.}
}
\value{
A list or vector of the RSI values.
}
\description{
This function computes the Relative Strength Index (RSI) for a time series.
}
\details{
To compute the RSI,

\deqn{\text{RSI} = 100 \dfrac{\text{Average\_gain}}{\text{Average\_gain}+\text{Average\_loss}}}

formula is used. Average gain and average loss are computed using the Wilders's smoothing method.
}
\examples{
X <- c(74.44,74.19,74.25,73.65,74.37,74.73,75.15,75.46,75.88,76.78,
            75.81,76.53,75.11,76.28,76.68,76.08,76.53,76.11,76.42,75.58,
            75.44,75.46,74.98)
RS_Index(X, plot = TRUE)

}
\references{
Wilder, J. W. (1978). New concepts in technical trading systems. Greensboro, NC.
}
