% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_power.R
\name{gof_power}
\alias{gof_power}
\title{Power estimation of goodness-of-fit tests.}
\usage{
gof_power(
  pnull,
  vals = NA,
  rnull,
  ralt,
  param_alt,
  w = function(x) -99,
  phat = function(x) -99,
  TS,
  TSextra,
  With.p.value = FALSE,
  alpha = 0.05,
  Range = c(-Inf, Inf),
  B = 1000,
  nbins = c(50, 10),
  rate = 0,
  maxProcessor,
  minexpcount = 5,
  ChiUsePhat = TRUE
)
}
\arguments{
\item{pnull}{function to find cdf under  null hypothesis}

\item{vals}{=NA values of discrete random variable, or NA}

\item{rnull}{function to generate data under  null hypothesis}

\item{ralt}{function to generate data under  alternative hypothesis}

\item{param_alt}{vector of parameter values for distribution under alternative hypothesis}

\item{w}{(Optional) function to calculate weights, returns -99 if no weights}

\item{phat}{=function(x) -99 function to estimate parameters from the data, or -99}

\item{TS}{user supplied function to find test statistics}

\item{TSextra}{list provided to TS (optional)}

\item{With.p.value}{=FALSE does user supplied routine return p values?}

\item{alpha}{=0.05, the level of the hypothesis test}

\item{Range}{=c(-Inf, Inf) limits of possible observations, if any}

\item{B}{=1000 number of simulation runs}

\item{nbins}{=c(50,10), number of bins for chi square tests.}

\item{rate}{=0 rate of Poisson if sample size is random, 0 if sample size is fixed}

\item{maxProcessor}{maximum of number of processors to use, 1 if no parallel processing is needed or number of cores-1 if missing}

\item{minexpcount}{=5 minimal expected bin count required}

\item{ChiUsePhat}{= TRUE, if TRUE param is estimated parameter, otherwise minimum chi square method is used.}
}
\value{
A numeric matrix of power values.
}
\description{
Find the power of various goodness-of-fit tests.
}
\details{
For details on the usage of this routine consult the vignette with vignette("Rgof","Rgof")
}
\examples{
# Power of tests when null hypothesis specifies the standard normal distribution but 
# true data comes from a normal distribution with mean different from 0.
pnull = function(x) pnorm(x)
rnull = function()  rnorm(50)
ralt = function(mu)  rnorm(50, mu)
TSextra = list(qnull=function(x) qnorm(x))
gof_power(pnull, NA, rnull, ralt, c(0.25, 0.5), TSextra=TSextra, B=200)
# Power of tests when null hypothesis specifies normal distribution and 
# mean and standard deviation are estimated from the data. 
# true data comes from a normal distribution with mean different from 0.
pnull = function(x, p=c(0, 1)) pnorm(x, p[1], ifelse(p[2]>0.001, p[2], 0.001))
rnull = function(p=c(0, 1))  rnorm(50, p[1], ifelse(p[2]>0.001, p[2], 0.001))
ralt = function(mu)  rnorm(50, mu)
phat = function(x) c(mean(x), sd(x))
TSextra = list(qnull = function(x, p=c(0, 1)) qnorm(x, p[1],  
               ifelse(p[2]>0.001, p[2], 0.001))) 
pwr=gof_power(pnull, NA, rnull, ralt, c(0, 1), phat=phat, TSextra=TSextra, B=200)
pwr
#' Compare power of a new test based on variants of the Cramer-vonMises
#' criterion to the methods included in the package: 
newTS = function(x, pnull, param) {
   Fx=sort(pnull(x, param))
   n=length(x)
   out = c(sum(abs( (2*1:n-1)/2/n-Fx )), sum(sqrt(abs( (2*1:n-1)/2/n-Fx ))))
   names(out) = c("CvM alt 1","CvM alt 2")
   out
}
#' Compare power to Lilliefors KS test, which finds its own p value:
LLtest=function(x, pnull, param) {
  out=nortest::lillie.test(x)$p.value
  names(out)="KS - Lilliefors"
  out
}
cbind(gof_power(pnull, NA, rnull, ralt, c(0, 1), TS=LLtest, phat=phat, 
       With.p.value=TRUE, TSextra=TSextra, B=200), pwr)
# Power of tests when null hypothesis specifies Poisson rv with rate 100 and 
# true rate is 100.5
vals = 0:250
pnull = function() ppois(0:250, 100)
rnull =function () table(c(0:250, rpois(1000, 100)))-1
ralt =function (p) table(c(0:250, rpois(1000, p)))-1
gof_power(pnull, vals, rnull, ralt, param_alt=100.5,  B=200)
# Power of tests when null hypothesis specifies a Binomial n=10 distribution 
# with the success probability estimated
vals = 0:10
pnull=function(p) pbinom(0:10, 10, ifelse(0<p&p<1, p, 0.001))
rnull=function(p) table(c(0:10, rbinom(1000, 10, ifelse(0<p&p<1, p, 0.001))))-1
ralt=function(p) table(c(0:10, rbinom(1000, 10, p)))-1
phat=function(x) mean(rep(0:10,x))/10
gof_power(pnull, vals, rnull, ralt, c(0.5, 0.6), phat=phat, B=200)

}
