% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DaviesBouldinIndex.R
\name{DaviesBouldinIndex}
\alias{DaviesBouldinIndex}
\title{Davies-Bouldin index}
\usage{
DaviesBouldinIndex(data, FHW_output, distance)
}
\arguments{
\item{data}{Matrix with \code{dim(data)[1]} points of \code{dim(data)[2]} dimensions.}

\item{FHW_output}{List. List with:

\itemize{
  \item centers: the information of the centers updated.
  \item grouping: the information of the groups updated. List. Each component of the list contains a vector with the points that belong to that group. More specifically, the list component i has a vector with the numbers of the row of the matrix \code{data} where the points belonging to group i are.
   }}

\item{distance}{Function. This function designs how the distance is going to be calculated. It must have as input two vectors and as output the distance of these vectors.}
}
\value{
Returns a number, the value of the Davies-Bouldin index.
}
\description{
This function calculates the Davies-Bouldin index as is defined by Davies and Bouldin (1979) without imposing that the use of the euclidean distance. This function allows calculating the Davies-Bouldin index using different distances.
}
\examples{

set.seed(451)
data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),
          matrix(runif(20,20,30), nrow = 2, ncol = 10),
          matrix(runif(20,50,70), nrow = 2, ncol = 10))
k=3
seed=5


FHW_output=Hartigan_and_Wong(data,
                            Euclideandistance,
                            k,
                            centers_function_mean,
                            init_centers_random,
                            seed=seed,
                            10)

DaviesBouldinIndex(data, FHW_output, Euclideandistance)

}
\references{
Davies, D. L., & Bouldin, D. W. (1979). A cluster separation measure. IEEE transactions on pattern analysis and machine intelligence, (2), 224-227.
}
