% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_PLP.R
\name{do.plp}
\alias{do.plp}
\title{Piecewise Laplacian-based Projection (PLP)}
\usage{
do.plp(X, ndim = 2, type = c("proportion", 0.2))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
\code{do.plp} is an implementation of Piecewise Laplacian-based Projection (PLP) that
adopts two-stage reduction scheme with local approximation.
}
\details{
First step is to select \eqn{\sqrt{n}} number of control points using \eqn{k}-means algorithm.
After selecting control points that play similar roles as representatives of the entire data points,
it performs classical multidimensional scaling.

For the rest of the data other than control points,
Laplacian Eigenmaps (\code{\link{do.lapeig}}) is then applied to high-dimensional data points
lying in neighborhoods of each control point. Embedded low-dimensional local manifold is then
aligned to match their coordinates as of their counterparts from classical MDS.
}
\section{Notes}{

\emph{Random Control Points} : The performance of embedding using PLP heavily relies on
selection of control points, which is contingent on the performance of \eqn{k}-means
clustering.

\emph{User Interruption} : PLP is actually an interactive algorithm that a user should be able to intervene
intermittently. Such functionality is, however, sacrificed in this version.
}

\examples{
\dontrun{
## use iris data
data(iris)
X     = as.matrix(iris[,1:4])
label = as.integer(iris$Species)

## try with 3 levels of connectivity
out1 = do.plp(X, type=c("proportion", 0.1))
out2 = do.plp(X, type=c("proportion", 0.2))
out3 = do.plp(X, type=c("proportion", 0.5))

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, col=label, main="PLP::10\% connected")
plot(out2$Y, col=label, main="PLP::20\% connected")
plot(out3$Y, col=label, main="PLP::50\% connected")
par(opar)
}

}
\references{
\insertRef{paulovich_piece_2011}{Rdimtools}
}
\author{
Kisung You
}
\concept{nonlinear_methods}
