% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zooplot_segments.R
\name{zooplot_hbdseg}
\alias{zooplot_hbdseg}
\title{Plot HBD segments identified with the ZooROH model}
\usage{
zooplot_hbdseg(
  input,
  chr = NULL,
  coord = NULL,
  minlen = 0,
  cols = NULL,
  plotids = TRUE,
  toplot = NULL,
  randomids = FALSE,
  nrandom = (rep(10, length(input))),
  seed = 100
)
}
\arguments{
\item{input}{a named list with one or several zres objects obtained after
running zoorun. The zres objects are the output of the zoorun function. For
instance, putting list(name1 = zres1, name2 = zres2). The function will then
use the names in the plot (in case several zres objects are used).}

\item{chr}{the number of the chromosome where we are looking for HBD segments.
This chromosome number refers to the position of the chromosome in the list
of all chromsomes present in the input genotype data.}

\item{coord}{a vector with the start and end position (in bp) of the region to
plot.}

\item{minlen}{the minimal length (in cM or Mb) of HBD segments to be plotted
(set to 0 by default).}

\item{cols}{a vector with the colors to be used for each population or zres
object.}

\item{plotids}{a logical indicating whether the IDs of the individuals are
plotted on the graph (TRUE by default).}

\item{toplot}{a list of vectors indicating the zres@ids to be plotted. This
option can be used to select the individuals to plot. The list must contain
one vector per population or zres object. By default, all individuals are
plotted.}

\item{randomids}{a logical indicating whether a randomset of individuals is
plotted. This option allows to reduce the number of individuals in the plot.
The option can not be used simultaneously with the toplot option. By
default, randomids is FALSE.}

\item{nrandom}{a vector indicating the number of individuals to be randomly
sampled per population or per zres object when randomids is TRUE. By
default, we select 10 individuals per zres object. This vector must have the
same length as the input list.}

\item{seed}{a value for the random seed used to sample individuals to plot
(when the randomids option is TRUE).}
}
\value{
The function plots the HBD segments identified in the region, using
 different colors for different zres object. Each line represents a different
 individual.
}
\description{
Plot HBD segments identified with the ZooRoH model for one or several
populations.
}
