% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoibeta.R
\name{zoibeta}
\alias{zoibeta}
\alias{dzoibeta}
\alias{pzoibeta}
\alias{rzoibeta}
\title{Zero- and one-inflated beta distribution}
\usage{
dzoibeta(x, shape1, shape2, zeroprob = 0, oneprob = 0, log = FALSE)

pzoibeta(q, shape1, shape2, zeroprob = 0, oneprob = 0,
         lower.tail = TRUE, log.p = FALSE)

rzoibeta(n, shape1, shape2, zeroprob = 0, oneprob = 0)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{shape1, shape2}{non-negative shape parameters of the beta distribution}

\item{zeroprob}{zero-inflation probability between 0 and 1.}

\item{oneprob}{zero-inflation probability between 0 and 1.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return.}
}
\value{
\code{dzoibeta} gives the density, \code{pzoibeta} gives the distribution function, and \code{rzoibeta} generates random deviates.
}
\description{
Density, distribution function, and random generation for
the zero-one-inflated beta distribution.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.
}
\examples{
set.seed(123)
x <- rzoibeta(1, 2, 2, 0.2, 0.3)
d <- dzoibeta(x, 2, 2, 0.2, 0.3)
p <- pzoibeta(x, 2, 2, 0.2, 0.3)
}
