% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPOTIS.R
\name{apply.SPOTIS}
\alias{apply.SPOTIS}
\title{Apply the Stable Preference Ordering Towards Ideal Solution (SPOTIS) method}
\usage{
apply.SPOTIS(matrix, weights, types, bounds)
}
\arguments{
\item{matrix}{A numeric matrix or data frame where rows represent alternatives and columns represent criteria.}

\item{weights}{A numeric vector of weights for each criterion. The sum of weights must equal 1.}

\item{types}{A numeric vector indicating the type of each criterion: 1 for profit and -1 for cost.}

\item{bounds}{A numeric matrix where each row contains the minimum and maximum bounds for each criterion.}
}
\value{
A numeric vector of preference scores for alternatives. Lower scores indicate better alternatives.
}
\description{
Apply the Stable Preference Ordering Towards Ideal Solution (SPOTIS) method
}
\examples{
# Decision matrix
matrix <- matrix(c(10.5, -3.1, 1.7,
                   -4.7, 0, 3.4,
                   8.1, 0.3, 1.3,
                   3.2, 7.3, -5.3), nrow = 4, byrow = TRUE)

# Criteria bounds
bounds <- matrix(c(-5, 12,
                   -6, 10,
                   -8, 5), nrow = 3, byrow = TRUE)

# Criteria weights
weights <- c(0.2, 0.3, 0.5)

# Criteria types
types <- c(1, -1, 1)

# Apply SPOTIS
preferences <- apply.SPOTIS(matrix, weights, types, bounds)

}
