% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MULTIMOORA.R
\name{apply.MULTIMOORA}
\alias{apply.MULTIMOORA}
\title{Apply MULTIMOORA method}
\usage{
apply.MULTIMOORA(mat, beneficial.vector)
}
\arguments{
\item{mat}{A matrix of decision-making criteria values.}

\item{beneficial.vector}{A vector containing the column indices of beneficial criteria (1-based indexing).}
}
\value{
A list of matrices containing rankings for MOORA, MOORA RP, and MULTIMOORA methods.
}
\description{
Apply MULTIMOORA method
}
\examples{
mat <- matrix(c(75.5, 95, 770, 187, 179, 239, 237,
                420, 91, 1365, 1120, 875, 1190, 200,
                74.2, 70, 189, 210, 112, 217, 112,
                2.8, 2.68, 7.9, 7.9, 4.43, 8.51, 8.53), nrow = 4, byrow = TRUE)
beneficial.vector <- c(1, 3) # Columns 1 and 3 are beneficial
apply.MULTIMOORA(mat, beneficial.vector)
}
