% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gspaceMethods.R
\name{names,GraphSpace-method}
\alias{names,GraphSpace-method}
\alias{names}
\alias{names<-}
\alias{gs_vcount}
\alias{gs_ecount}
\alias{gs_vertex_attr}
\alias{gs_edge_attr}
\alias{gs_vertex_attr<-}
\alias{gs_edge_attr<-}
\alias{names<-,GraphSpace-method}
\alias{gs_vcount,GraphSpace-method}
\alias{gs_ecount,GraphSpace-method}
\alias{gs_vertex_attr,GraphSpace-method}
\alias{gs_vertex_attr<-,GraphSpace-method}
\alias{gs_edge_attr,GraphSpace-method}
\alias{gs_edge_attr<-,GraphSpace-method}
\title{Accessors for applying essential igraph methods to modify
attributes of GraphSpace objects.}
\usage{
\S4method{names}{GraphSpace}(x)

\S4method{names}{GraphSpace}(x) <- value

\S4method{gs_vcount}{GraphSpace}(x)

\S4method{gs_ecount}{GraphSpace}(x)

\S4method{gs_vertex_attr}{GraphSpace}(x, name, ...)

\S4method{gs_vertex_attr}{GraphSpace}(x, name, ...) <- value

\S4method{gs_edge_attr}{GraphSpace}(x, name, ...)

\S4method{gs_edge_attr}{GraphSpace}(x, name, ...) <- value
}
\arguments{
\item{x}{A \linkS4class{GraphSpace} class object}

\item{value}{The new value of the attribute.}

\item{name}{Name of the attribute.}

\item{...}{Additional arguments passed to igraph methods.}
}
\value{
Updated \linkS4class{GraphSpace} object.
}
\description{
Access and modify individual slots of a GraphSpace 
object. Selected 'igraph' methods are applied to the 'graph' slot and 
propagated to downstream components.
}
\examples{
# Load a demo igraph
data('gtoy1', package = 'RGraphSpace')

# Create a new GraphSpace object
gs <- GraphSpace(gtoy1)

# Usage of GraphSpace attribute accessors:

# Get vertex names
names(gs)

# Get vertex count
gs_vcount(gs)

# Get edge count
gs_ecount(gs)

# Access all vertex attributes
gs_vertex_attr(gs)

# Access a specific vertex attribute
gs_vertex_attr(gs, "nodeLabel")

# Modify a single value within a vertex attribute
gs_vertex_attr(gs, "nodeSize")["n1"] <- 10

# Replace an entire vertex attribute
gs_vertex_attr(gs, "nodeSize") <- 10

# Alternative syntax using `$` accessor
gs_vertex_attr(gs)$nodeSize <- 10

# Access a specific edge attribute
gs_edge_attr(gs, "edgeLineColor")

# Replace an entire edge attribute
gs_edge_attr(gs, "edgeLineWidth") <- 1

 # Alternative syntax using `$` for edge attributes
gs_edge_attr(gs)$edgeLineWidth <- 3

}
\seealso{
\code{\link[igraph]{vertex_attr}}, \code{\link[igraph]{edge_attr}}
}
