% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_parallel.R
\name{setup_parallel}
\alias{setup_parallel}
\title{Setup Parallel Processing for Portfolio Analysis}
\usage{
setup_parallel(num_cores = 7)
}
\arguments{
\item{num_cores}{The default number of cores to use for parallel processing. Default is 7.}
}
\value{
A parallel cluster object that can be used with functions that support parallel computation.
}
\description{
This function sets up parallel processing by loading necessary libraries, allowing the user to specify the
number of cores to use, and creating a parallel backend for faster computation.
}
\details{
This function allows the user to specify the number of cores for parallel processing either through the
argument \code{num_cores} or via interactive user input. The function also loads a set of libraries required for
portfolio analysis.
}
\examples{
# Set up parallel processing with a specified number of cores
cl <- setup_parallel(num_cores = 2)  # Use 2 cores for the example
print(cl)  # Print the cluster information
parallel::stopCluster(cl)  # Stop the cluster after use to clean up
}
